/*
 * Pidgin - Dockapp plugin
 *
 * Copyright (C) 2008, Marek Wardzinski (emvi)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02111-1301  USA
 *
 */

#ifndef _DOCKAPP_H_
#define _DOCKAPP_H_

/* max icons on dockapp window */
#define DOCKAPP_ICONS 3

/* static options for icons */
#define DOCKAPP_ICONS_OTHER_SELECTS 3

/* max buddy changes on dockapp window */
#define DOCKAPP_BUDDIES 3

/* buddy state colors */
#define DOCKAPP_COLORS 3

/* default colors */
#define DOCKAPP_DEFAULT_COLOR_OFFLINE "#FF0000"
#define DOCKAPP_DEFAULT_COLOR_ONLINE "#00FF00"
#define DOCKAPP_DEFAULT_COLOR_AWAY "#0000FF"

/* Buddy types of colors */
enum DockappBuddyColorTypes {
    dockapp_offline_color,
    dockapp_online_color,
    dockapp_away_color
};

void *dockapp_get_handle();
gboolean dockapp_load(PurplePlugin * plugin);
gboolean dockapp_unload(PurplePlugin * plugin);
void dockapp_destroy(PurplePlugin * plugin);

gboolean dockapp_window_clicked(GtkWidget * widget, GdkEventButton * event, gpointer user_data);
void dockapp_update_icons_all();
static void dockapp_update_icon(PurpleAccount * account, const char *account_username,
                                gboolean connecting);
void dockapp_buddies_colorize();
void dockapp_buddies_shift_up();
gboolean dockapp_icon_blinker(gpointer data);
gboolean dockapp_iconmsg_blinker(gpointer data);

#endif /* _DOCKAPP_H_ */
